# Affects structure. This is **OPAQUE**, because the implementation may change.
# {
#   <affected field name> => {
#     <affect tag> => <amount changed>,
#   },
# },
# Actual amount field is changed by is total of all <amount changed>s.

use Carp;

MObject->Fields (
  affects => {default => {}, noset => 1},
  wear_aff => {default => {}},
);

MObject->Methods (

aff_add => sub {
  my ($self, $atag, $afield, $aval) = @_;
  
  $self->localize_field('affects');
  my $affs = $self->affects;
  exists $affs->{$afield}{$atag} and do {carp "Attempted to create already-existing affect tag '$atag' for field '$afield' on object #".$self->id."!"; return};
  $affs->{$afield}{$atag} = $aval;
  $self->set_val($afield, $self->get_val($afield) + $aval);
},

aff_remove => sub {
  my ($self, $atag, $afield) = @_;
  
  my $affs = $self->affects;
  exists $affs->{$afield}{$atag} or do {carp "Attempted to remove non-existing affect tag '$atag' for field '$afield' on object #".$self->id."!"; return};
  my $aval = $affs->{$afield}{$atag};
  delete $affs->{$afield}{$atag};
  %{$affs->{$afield}} or delete ${$affs}{$afield};
  my $new_val = $self->get_val($afield) - $aval;
  my $proto = MIndex->get('proto')->get($self->prototype);
  my $proto_val = $proto ? $proto->get_val($afield) : MObject->field_info($afield)->{default};
  if ($proto_val != $new_val) {
    $self->set_val($afield, $new_val);
  } else {
    delete $self->{$afield};
  }
},

);

=for FIXME

MLoaders->Hooks (
slot_added => sub {
  my ($target, $self) = @_;
  
  while (my ($k, $v) = each %{$self->wear_aff}) {
    $target->aff_add("wear $self->{is_slot}", $k, $v);
  }
},

slot_removed => sub {
  my ($target, $self) = @_;
  
  while (my ($k) = each %{$self->wear_aff}) {
    $target->aff_remove("wear $self->{is_slot}", $k);
  }
},

);

=cut

MObject->Commands (
unaffect => {
  requires => [qw(runner builder)],
  code => sub {
    my ($self, $args) = @_;
    $args or do {
      $self->send("Unaffect what??");
      return;
    };
    my $obj = $self->get_any_object($args) or do {
      $self->send("You do not see that here.");
      return;
    };
    while (my ($field) = each %{$obj->affects}) {
      while (my ($atag) = each %{$obj->affects->{$field}}) {
        $obj->aff_remove($atag, $field);
      }
    }
    $self->send("Unaffected ".$obj->nphr);
  },
},

'@affect' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;

    my ($field, $value) = split /\s+/, $args, 2;
    my $obj = $self->edit_target_obj;
    $obj->localize_field('wear_aff');
    my $affs = $obj->wear_aff;
    
    if ($value eq 'delete') {
      delete $affs->{$field};
    } elsif ($value) {
      $affs->{$field} = $value;
    } else {
      $self->send('Specify a value or "delete".');
    }
    
    $self->edit_target_make_dirty();
  },
  help => <<'EOHELP',
@affect &g<field>&n &g<value>&c|&n;delete

The &y;@affect&n command sets wear affects for an object.
EOHELP
},
);
